//------------------------------------------------------------
// Copyright Sandlot Games, 2007
// author: Michael Felice
// file: client_character.cs
// brief:
//    This handles all of the client-side character details
//    that need to be address when the character is first
//    created (not from a mission file when loaded)
//------------------------------------------------------------



//*************************************************************
//           CLIENT-SIDE CHARACTER STATES
//*************************************************************

// this function is called once when a character is created for
// the first time (not when it is loaded from a mission file,
// only when it is newly created)
function CharacterClient::onInitialize(%this, %input)
{
   %object = getWord(%input, 0);
   %component = getWord(%input, 1);
   %datablock = %component.getDataBlock();
   slgUpdateLocatorButtons();
   if ($LoadMission == false && $PlayingGame == true && %object.isOnTeam($OST_PLAYER))
   {
      chooseAmbientSound();
   }
   
   // if the character starts off invisible, turn off its collision
   if (%object.showMesh == false)
   {
      %object.disableCollision();
   }
   
   // create the selection icon for the object
   %icon = new SLSelectIcon()
   {
      // bitmap gui control functionality
      extent = "30 47";
      visible = ".5";
      bitmap = "assets/client/ui/selecticonup.png";
      
      // base object
      target = %object;
      renderFront = true;
      bboxHeight = true;
      worldOffset = "0 0 1.8";
      
      // select icon object
      highlightImage = "assets/client/ui/selecticonfocus";
      selectedImage = "assets/client/ui/selecticonselected";
   };
   TaskButtonGroup.addGuiControl(%icon);
   %object.selectIcon = %icon;
   
   // Send object create message
   slgSendObjCreateMsg(%object, true);
}

// this function is called once on every tick for the client-side
// character object
function CharacterClient::onUpdate(%this, %input)
{
   %object = getWord(%input, 0);
   %component = getWord(%input, 1);
   %datablock = %component.getDataBlock();
}

// this function is called when the character object is removed
function CharacterClient::onRemove(%this, %input)
{
   %component = getWord(%input, 0);
   %datablock = %component.getDataBlock();
   slgUpdateLocatorButtons();
   if ($LoadMission == false && $PlayingGame == true)
   {
      chooseAmbientSound();
   }
}

// this function is called when the character's state has changed
function CharacterClient::onStateChange(%this, %state, %set)
{
   %object = slgGetAttachedObjId(%this);
   if (isSelected(%object) == true)
   {
      csUpdateCharSelectionPanelStatus(%this);
   }
   
   // if the character is being reformed then add the reform icon
   if (%this.inState($CharacterState::Reform))
   {
      CreateReformIcon(%object);
   }
   else
   {
      DestroyReformIcon(%object);
   }
}

// tests if the character is disabled for any reason
function CharacterClient::isDisabled(%this)
{
   if (%this.inState($CharacterState::Drunk))
   {
      return true;
   }
   
   // not disabled by default
   return false;
}

// called when a character's employment status has changed
function CharacterClient::onEmploymentChange(%this, %workplace)
{
   // update locator buttons
   slgUpdateLocatorButtons();
}

function clientCmdClearDestination(%ghostID)
{
   %object = ServerConnection.resolveGhostID(%ghostID);
   if (isObject(%object) == false)
   {
      return;
   }
   %object.ClearDestination();
}
